import sys
import re
import os
import binascii
import subprocess
#import colorama
from colorama import Fore, Back, Style, init

#colorama.init()
init()

def rom_info(get_info) :
	t_position = 0
	ifr_header = False
	rom_found  = False
	t_old_type = False
	t_rom_pat  = re.compile(br'\x55\xAA')
	mini_me    = True if get_info == "mini" else False
	
	## Checking for Nvidia IFR header
	nv_ifr_test = reading[0:4].decode('utf-8', 'ignore')
	if nv_ifr_test == "NVGI" :
		ifr_header = True
		#ifr_size   = int(binascii.hexlify(reading[0x14:0x16][::-1]), 16)
		ifr_size   = int.from_bytes(reading[0x14:0x16], 'little')
		t_position = ifr_size
		if mini_me :
			print(Fore.GREEN + "Found Nvidia IFR header before ROM start, size 0x%X\n" % ifr_size + Fore.RESET)
			ifr_id = binascii.hexlify(reading[0xC:0x10][::-1]).decode('utf-8').upper()
			ifr_id = ifr_id[4:] + "-" + ifr_id[:4]
			print(Fore.GREEN + "ID of IFR header  = %s\n" % ifr_id + Fore.RESET)
	
	## Not really needed, but it is safe. The ROM should start at 00 or at ifr_size.
	while not rom_found :
		
		t_rom_match = t_rom_pat.search(reading, t_position)
		
		if t_rom_match is None :
			
			print(Fore.RED + "No ROM found!\n" + Fore.RESET)
			file_dec = "%s_decompr.bin" % file_rom
			
			if not os.path.isfile(file_dec) :
				print(Fore.RED + "Trying direct decompression...\n" + Fore.RESET)
				decomp = subprocess.call(["UEFIRomExtract", file_dir, file_dec], shell=True)
				print("")
				
				if os.path.isfile(file_dec) :
					print(Fore.YELLOW + "File " + file_dec + " was written! \n" + Fore.RESET)
			
			sys.exit()
		
		(t_start_match, t_end_match) = t_rom_match.span()
		t_start_pcir = int.from_bytes(reading[t_start_match + 0x18:t_start_match + 0x1A], 'little')
		#print("0x%0.2X - 0x%0.2X" % (t_start_match, t_start_pcir))
		
		if t_start_pcir == 0 :
			t_start_pnp = int.from_bytes(reading[t_start_match + 0x1A:t_start_match + 0x1C], 'little')
			t_pnp_off   = t_start_match + t_start_pnp
			t_pnp_str   = reading[t_pnp_off:t_pnp_off + 4].decode('utf-8', 'ignore')
			if t_pnp_str != "$PnP" :
				#print("No PnP\n")
				t_position = t_start_match + 2
				continue
			t_start_pcir = 0x20
		
		t_pcir_off = t_start_match + t_start_pcir
		t_pcir_str = reading[t_pcir_off:t_pcir_off + 4].decode('utf-8', 'ignore')
		#print (t_pcir_str)
		
		if t_pcir_str != "PCIR" :
			#print("No PCIR\n")
			t_position = t_start_match + 2
			continue
		
		## Only first image needed
		rom_found = True
	
	## Get some ROM related info
	t_pcir_id_bin = reading[t_pcir_off + 4:t_pcir_off + 8]
	t_pcir_id_hex = binascii.hexlify(t_pcir_id_bin[::-1]).decode('utf-8').upper()
	t_ven_id      = t_pcir_id_hex[4:]
	t_did_id      = t_pcir_id_hex[:4]
	
	if mini_me :
		## Only Nvidia IFR found so far as header before ROM
		if t_start_match and not ifr_header :
			print(Fore.MAGENTA + "Found Unknown header before ROM start, size 0x%X\n" % t_start_match + Fore.RESET)
		
		print(Style.BRIGHT + Fore.CYAN + "ID of ROM file    = %s-%s\n" % (t_ven_id, t_did_id)  + Fore.RESET + Style.NORMAL)
		
		if t_ven_id == "10DE" and t_did_id in ['0FF2', '11BF'] :
			print(Style.BRIGHT + Fore.YELLOW + "Nvidia GRID K1/K2 was detected! Using Multi-Display GOP.\n" + Fore.RESET + Style.NORMAL)
	
	## Get boundaries and sizes
	if reading[t_start_match + 4:t_start_match + 6] == b'\xF1\x0E' : # \xF1\x0E\x00\x00
		## This part is only for extraction of single EFI ROM files
		t_rom_size  = 0
		t_rom_end   = t_start_match
		t_efi_found = True
		t_efi_begin = t_start_match
		
	else :
		## Calculate first ROM size. Sometimes the size from PCI DS is the right one.
		t_rom_size    = ord(reading[t_start_match + 2:t_start_match + 3]) * 0x200
		t_rom_size_ds = int.from_bytes(reading[t_pcir_off + 0x10:t_pcir_off + 0x12], 'little') * 0x200
		
		if t_rom_size != t_rom_size_ds :
			print(Fore.MAGENTA + "Different sizes in ROM header and PCI structure of Legacy ROM!\n" + Fore.RESET)
			t_rom_end_ds = t_start_match + t_rom_size_ds
			rom_test_ds  = reading[t_rom_end_ds:t_rom_end_ds + 2]
			if rom_test_ds in [b'\x55\xAA', b'\x56\x4E'] :
				t_rom_size = t_rom_size_ds
		
		## If all the images are contained in first ROM.
		#if reading[t_pcir_off + 0x20:t_pcir_off + 0x24] == b'NPDE' :
		#	t_npde_size = int.from_bytes(reading[t_pcir_off + 0x28:t_pcir_off + 0x2A], 'little') * 0x200
		#	
		#	if t_rom_size != t_npde_size :
		#		print(Fore.MAGENTA + "Different sizes in PCI structure and NPDE structure of Legacy ROM!\n" + Fore.RESET)
		#		## If the EFI image should be placed between Legacy and Special images, thus breaking the big container.
		#		t_rom_end_npde = t_start_match + t_npde_size
		#		rom_test_npde  = binascii.hexlify(reading[t_rom_end_npde:t_rom_end_npde + 2]).decode('utf-8').upper()
		#		if rom_test_npde in ['55AA', '564E'] :
		#			t_rom_size = t_npde_size
		
		t_rom_end   = t_start_match + t_rom_size
	
	## Not really needed, but it is safe. EFI should start at t_rom_end.
	## Assume that EFI follows OROM and that there is nothing in between.
	## The only structure found so far was Legacy ROM + EFI ROM, no other images in between.
	
	t_pat_efi   = re.compile(br'\x55\xAA..\xF1\x0E', re.DOTALL) # \xF1\x0E\x00\x00
	t_match_efi = t_pat_efi.search(reading, t_rom_end)
	
	if t_match_efi is not None :
		(t_start_efi_match, t_end_efi_match) = t_match_efi.span()
		t_efi_found = True
		t_efi_begin = t_start_efi_match
		
		# Scan for special images between ROM and GOP
		while reading[t_rom_end:t_rom_end + 2] == b'\x56\x4E' :
			npds_ptr  = int.from_bytes(reading[t_rom_end + 0x18:t_rom_end + 0x1A], 'little')
			npds_off  = t_rom_end + npds_ptr
			npds_size = int.from_bytes(reading[npds_off + 0x10:npds_off + 0x12], 'little') * 0x200
			npds_type = "%02Xh" % ord(reading[npds_off + 0x14:npds_off + 0x15])
			t_rom_end += npds_size
			
			if mini_me :
				print(Style.BRIGHT + Fore.YELLOW + "Found special image %s between ROM and EFI!\n" % npds_type + Fore.RESET)
		
		# Skip intermediate images for other types of images. Only for extraction. They will be skipped later.
		while t_ven_id not in ['1002', '10DE'] and reading[t_rom_end:t_rom_end + 2] == b'\x55\xAA' :
			temp_pcir = int.from_bytes(reading[t_rom_end + 0x18:t_rom_end + 0x1A], 'little')
			temp_off  = t_rom_end + temp_pcir
			
			if reading[temp_off:temp_off + 4] != b'PCIR' or reading[t_rom_end + 4:t_rom_end + 6] == b'\xF1\x0E' :
				break
			
			temp_size    = ord(reading[t_rom_end + 2:t_rom_end + 3]) * 0x200
			tmp_size_ds  = int.from_bytes(reading[temp_off + 0x10:temp_off + 0x12], 'little') * 0x200
			
			if temp_size != tmp_size_ds :
				t_rom_end_ds = t_rom_end + tmp_size_ds
				rom_test_ds  = reading[t_rom_end_ds:t_rom_end_ds + 2]
				
				if rom_test_ds in [b'\x55\xAA', b'\x56\x4E'] :
					temp_size = tmp_size_ds
			
			t_rom_end += temp_size
				
		if t_efi_begin != t_rom_end :
			print(Style.BRIGHT + Fore.RED + "Data between ROM and EFI! Please report it\n" + Fore.RESET)
			sys.exit()
		
	else :
		#t_start_efi_match = 0
		t_efi_found = False
		t_efi_begin = t_rom_end
	
	if t_efi_found :
		t_efi_size = int.from_bytes(reading[t_efi_begin + 2:t_efi_begin + 4], 'little') * 0x200
		if mini_me :
			return (t_efi_found, t_efi_begin, t_efi_size)
	else :
		if mini_me :
			return (t_efi_found, 0, 0)
		
		## Check for a dummy EFI image. If it starts with 564E, it is a special Nvidia image.
		## If it is dummy EFI, the first two bytes are 77BB.
		
		t_ven_id = t_pcir_id_hex[4:]
		
		if t_ven_id == "10DE" :
			
			test_image = reading[t_efi_begin:t_efi_begin + 2]
			
			## Test for dummy EFI in Nvidia.
			if len(test_image) == 2 and test_image != b'\x56\x4E' : ## 55AA or 77BB = old structure or dummy
				pci_ds_efi   = int.from_bytes(reading[t_efi_begin + 0x18:t_efi_begin + 0x1A], 'little')
				pcir_efi_off = t_efi_begin + pci_ds_efi
				t_struct     = reading[pcir_efi_off:pcir_efi_off + 4].decode('utf-8', 'ignore').upper()
				
				## Old images have the special Nvidia images as normal ROMs
				if test_image == b'\x55\xAA' and t_struct == "PCIR" :
					print(Style.BRIGHT + Fore.YELLOW + "Old structure was found in special images!\n" + Fore.RESET + Style.NORMAL)
					t_old_type = True
					t_efi_size = 0
				## A dummy EFI should have only one of the following two structures.
				elif test_image == b'\x77\xBB' and t_struct in ['NPDS', 'RGIS'] :
					print(Style.BRIGHT + Fore.YELLOW + "Dummy EFI image was found!\n" + Fore.RESET + Style.NORMAL)
					t_efi_size = int.from_bytes(reading[pcir_efi_off + 0x10:pcir_efi_off + 0x12], 'little') * 0x200
				## Not old image, not dummy, not special image. What can it be?
				else :
					print(Style.BRIGHT + Fore.RED + "Strange Nvidia image was found after ROM! Please report it!\n" + 
					Fore.RESET + Style.NORMAL)
					t_efi_size = 0
			
			## No more images or Nvidia special image.
			else :
				t_efi_size = 0
		
		## Is AMD and AMD has no dummy EFI and no other images, from what I have seen.
		else :
			t_efi_size = 0
			
			mc_off_list = [0x1A000, 0x1B800, 0x1C000]
			
			for mc_off_idx in mc_off_list :
				
				mc_off     = t_start_match + mc_off_idx
			
				if reading[mc_off:mc_off + 4] == b'MCuC' :
					print(Style.BRIGHT + Fore.YELLOW + "AMD microcode was found at offset 0x%0.2X!\n" % mc_off + 
					Fore.RESET + Style.NORMAL)
					break
				
	return (t_old_type, t_start_match, t_pcir_off, t_pcir_id_bin, t_pcir_id_hex, t_rom_size, t_efi_found, t_efi_begin, t_efi_size)

def efi_version(t_efi_dump) :
	t_gop_type = ""
	t_nv_type  = ""
	t_version  = ""
	t_efi_info_string = ""
	
	## AMD GOP
	pat_amd   = re.compile(br'\x44\x00\x72\x00\x69\x00\x76\x00\x65\x00\x72\x00\x20\x00\x52\x00\x65\x00\x76\x00') ## D.r.i.v.e.r. .R.e.v.
	match_amd = pat_amd.search(t_efi_dump)
	
	if match_amd is not None :
		(ver_start_match, ver_end_match) = match_amd.span()
		t_gop_type = "AMD"
		t_version = lib_build = date = build = changelist = bios_idtf_gop = bios_idtf_rom = "0"
		
		t_version = t_efi_dump[ver_end_match + 2: ver_end_match + 0x1A].decode('utf-16', 'ignore').upper()
		
		if t_version[8:9] == "." :
			
			if t_version[:1] == "0" :
				t_version = t_version[:8]
			else :
				t_version = t_version[:10]
		
		verslen = 2 * len(t_version)
		lib     = ver_end_match + 4 + verslen
		test    = t_efi_dump[lib:lib + 6].decode('utf-16', 'ignore')
		
		if test == "Lib" : ## "4C0069006200"
			#print("Lib")
			lib_build = t_efi_dump[lib + 0x16:lib + 0x1E].decode('utf-16', 'ignore')
			date  = t_efi_dump[lib + 0x20:lib + 0x48].decode('utf-16', 'ignore')
		
		elif test.isalpha() :
			#print("None")
			lib_build = "----"
			date  = t_efi_dump[lib:lib + 0x28].decode('utf-16', 'ignore')
		
		elif test.isnumeric() :
			#print("Old")
			lib_build = t_efi_dump[lib:lib + 0xC].decode('utf-16', 'ignore')
			
			try :
				dot_off  = lib_build.index(".")
				date_off = lib + dot_off * 2 + 2
				lib_build = lib_build[:dot_off]
			except :
				date_off = lib + 0xE
				
			date  = t_efi_dump[date_off:date_off + 0x28].decode('utf-16', 'ignore')
		
		print(Style.BRIGHT + Fore.RED + "AMD GOP" + Fore.WHITE + " %s  " % t_version + 
		Fore.RED + "LibBuild" + Fore.WHITE + " %s  " % lib_build + 
		Fore.RED + "Dated:" + Fore.WHITE + " %s" % date.replace(".", " ") + 
		Fore.RESET + Style.NORMAL)
		
		t_efi_info_string = t_version + " - " + lib_build.replace("-", "*") + " - " + date.replace(".", " ")
		
		## BIOS_IDTF + AMD_Build + AMD_CL. Each one takes 0x18 bytes.
		pat_idtf   = re.compile(br'\x42\x49\x4F\x53\x5F\x49\x44\x54\x46') ## BIOS_IDTF
		match_idtf = pat_idtf.search(t_efi_dump)
		
		if match_idtf is not None :
			(idtf_start_match, idtf_end_match) = match_idtf.span()
			bios_idtf_gop = binascii.hexlify(t_efi_dump[idtf_start_match + 0xA:idtf_start_match + 0x18][::-1]).decode('utf-8').lstrip("0").upper()
		else :
			idtf_start_match = 0
		
		if idtf_start_match and t_efi_dump[idtf_start_match + 0x18:idtf_start_match + 0x21].decode('utf-8', 'ignore') == "AMD_Build" :
			bd_start_match = idtf_start_match + 0x18
			build = int.from_bytes(t_efi_dump[bd_start_match + 0xA:bd_start_match + 0x18], 'little')
		else :
			pat_bd   = re.compile(br'\x41\x4D\x44\x5F\x42\x75\x69\x6C\x64') ## AMD_Build
			match_bd = pat_bd.search(t_efi_dump)
			
			if match_bd is not None :
				(bd_start_match, bd_end_match) = match_bd.span()
				build = int.from_bytes(t_efi_dump[bd_start_match + 0xA:bd_start_match + 0x18], 'little')
			else :
				bd_start_match = 0
		
		if bd_start_match and t_efi_dump[bd_start_match + 0x18:bd_start_match + 0x1E].decode('utf-8', 'ignore') == "AMD_CL" :
			cl_start_match = bd_start_match + 0x18
			changelist = int.from_bytes(t_efi_dump[cl_start_match + 0xA:cl_start_match + 0x18], 'little')
		else :
			pat_cl   = re.compile(br'\x41\x4D\x44\x5F\x43\x4C') ## AMD_CL
			match_cl = pat_cl.search(t_efi_dump)
			
			if match_cl is not None :
				(cl_start_match, cl_end_match) = match_cl.span()
				changelist = int.from_bytes(t_efi_dump[cl_start_match + 0xA:cl_start_match + 0x18], 'little')
		
		pat_lg   = re.compile(br'\x41\x4D\x44\x20\x41\x54\x4F\x4D\x42\x49\x4F\x53\x00') ## AMD ATOMBIOS.
		match_lg = pat_lg.search(t_efi_dump)
		
		if match_lg is not None :
			(lg_start_match, lg_end_match) = match_lg.span()
			#print("\nAMD GOP has tables! Customized GOP with legacy parts!")
			bios_idtf_rom = binascii.hexlify(t_efi_dump[lg_start_match + 0xD:lg_start_match + 0x15][::-1]).decode('utf-8').lstrip("0").upper()
			#bios_idtf_rom = " ## Legacy BIOS_IDTF 0x" + bios_idtf_rom
		
			print(Style.BRIGHT + Fore.RED + "\nAMD_Build" + Fore.WHITE + " %s  " % build + 
			Fore.RED + "AMD_ChangeList" + Fore.WHITE + " %s  " % changelist + 
			Fore.RED + "GOP BIOS_IDTF" + Fore.WHITE + " 0x%s " % bios_idtf_gop + 
			"\n\nAMD GOP has tables! Customized GOP with legacy parts!!" + 
			Fore.RED + "\n\nLegacy BIOS_IDTF" + Fore.WHITE + " 0x%s " % bios_idtf_rom + 
			Fore.RESET + Style.NORMAL)
			
			t_efi_info_string += " - " + "%s" % build + " - " + "%s" % changelist + " - " + "0x%s" % bios_idtf_gop + \
			" - " + "0x%s" % bios_idtf_rom
		
		else :
			print(Style.BRIGHT + Fore.RED + "\nAMD_Build" + Fore.WHITE + " %s  " % build + 
			Fore.RED + "AMD_ChangeList" + Fore.WHITE + " %s  " % changelist + 
			Fore.RED + "GOP BIOS_IDTF" + Fore.WHITE + " 0x%s " % bios_idtf_gop + 
			Fore.RESET + Style.NORMAL)
			
			t_efi_info_string += " - " + "%s" % build + " - " + "%s" % changelist + " - " + "0x%s" % bios_idtf_gop
		
		## IDs in GOP. Works only with newer GOPs.
		
		# Alternative for ID search
		#pat_id_ptr   = re.compile(br'\x01\x01\x00{6}.{4}\x00{4}\x01\x02\x00{6}.{4}\x00{4}\x01\x03\x00{6}.{4}\x00{4}\x01\x04\x00{6}.{4}\x00{4}', re.DOTALL)
		#match_id_ptr = pat_id_ptr.search(t_efi_dump)
		#
		#if match_id_ptr is not None :
		#	(id_ptr_start_match, id_ptr_end_match) = match_id_ptr.span()
		#	id_start_match = int.from_bytes(t_efi_dump[id_ptr_start_match + 8:id_ptr_start_match + 0xC], 'little')
		
		pat_id   = re.compile(br'\x00{8}\x88\x68\x00{6}')
		match_id = pat_id.search(t_efi_dump)
		
		if match_id is not None :
			(id_start_match, id_end_match) = match_id.span()
			ids_list = ""
			step = id_start_match + 8
			
			while True :
				check_null = t_efi_dump[step + 2:step + 8]
				
				if check_null != b'\x00' * 6 : # "000000000000"
					break
				
				id = "1002-" + binascii.hexlify(t_efi_dump[step:step + 2][::-1]).decode('utf-8').upper()
				
				if id == "1002-0000" :
					step += 0x10
					continue
				
				if id == "1002-0101" :
					break
				
				name_off  = int.from_bytes(t_efi_dump[step + 8:step + 0xC], 'little')
				name_str  = ""
				name_step = name_off
				name_chr  = t_efi_dump[name_step:name_step + 1]
				
				while name_chr != b'\x00' :
					name_str  += name_chr.decode('utf-8', 'ignore')
					name_step += 1
					name_chr  = t_efi_dump[name_step:name_step + 1]
				
				ids_list += id + "  =  " + name_str + "\n"
				step     += 0x10
			
			with open("%s_temp\\AMD_GOP_%s_IDs.txt" % (file_rom, t_version), "a") as myfile :
				myfile.write(ids_list)
		
		## Names in GOP. Only AMD with GOPs newer than 1.34.0.0.0.
		#pat_name   = re.compile(br'\x41\x00\x6D\x00\x64\x00\x41\x00\x63\x00\x70\x00\x69\x00\x56\x00\x61\x00\x72\x00') ## A.m.d.A.c.p.i.V.a.r.
		#match_name = pat_name.search(t_efi_dump)
		#
		#if match_name is not None and int(t_version[2:4]) > 34 :
		#	#print("\nFound names")
		#	(name_start_match, name_end_match) = match_name.span()
		#	bin_test = t_efi_dump[name_end_match + 4:name_end_match + 0xE]
		#	str_test = bin_test.decode('utf-8', 'ignore')
		#	#print(bin_test)
		#	#print(str_test)
		#	
		#	if str_test == "CR has Bad" or bin_test == b'\x4C\x00\x4C\x00\x4C\x00\x4C\x00\x4C\x00' :
		#		#print("\nCR or LL")
		#		pat_name   = re.compile(br'\x00{4}\x65\x6E\x00{2}') ## ....en..
		#		match_name = pat_name.search(t_efi_dump)
		#		
		#		if match_name is not None :
		#			(name_start_match, name_end_match) = match_name.span()
		#			step = name_end_match
		#	
		#	else :
		#		#print("\nNewer names")
		#		step = name_end_match + 4
		#	
		#	gpu_list = ""
		#	gpu_char = t_efi_dump[step:step + 1]
		#	
		#	while True :
		#		gpu_name = ""
		#		
		#		while gpu_char != b'\x00' :
		#			gpu_name += gpu_char.decode('utf-8', 'ignore')
		#			step     += 1
		#			gpu_char = t_efi_dump[step:step + 1]
		#		
		#		if gpu_name[:11] in ['[ATI', 'Compromised', 'Protocol Er', 'Destination', 'ASSERT %a(%'] or len(gpu_name) < 3:
		#			break
		#		
		#		gpu_list += gpu_name + "\n"
		#						
		#		while gpu_char == b'\x00' :
		#			step     += 1
		#			gpu_char = t_efi_dump[step:step + 1]
		#		
		#	with open("%s_temp\\AMD_GOP_%s_names.txt" % (file_rom, t_version), "a") as myfile :
		#			myfile.write(gpu_list)
			
		return (t_gop_type, "", t_version, t_efi_info_string)

	## Nvidia GOP
	pat_nv = re.compile(br'\x4E\x56\x2D\x55\x45\x46\x49\x2D\x42\x4C\x44\x2D\x49\x4E\x46\x4F') ## NV-UEFI-BLD-INFO
	match_nv = pat_nv.search(t_efi_dump)
	
	if match_nv is not None :
		(nv_start_match, nv_end_match) = match_nv.span()
		t_gop_type = "Nvidia"
		date      = t_efi_dump[nv_end_match + 8:nv_end_match + 0x13].decode('utf-8', 'ignore')
		t_version = t_efi_dump[nv_end_match + 0x18:nv_end_match + 0x1F].decode('utf-8', 'ignore')
		chg       = t_efi_dump[nv_end_match + 0x24:nv_end_match + 0x2C].decode('utf-8', 'ignore')
		var_test  = t_efi_dump[nv_end_match + 0x2D:nv_end_match + 0x31]
		
		if var_test == b'VAR:' : ## 5641523A
			id_test = t_efi_dump[nv_end_match + 0x31:nv_end_match + 0x3C]
			
			if id_test == b'VARIANT_ID=' :
				var = t_efi_dump[nv_end_match + 0x3C:nv_end_match + 0x4C].decode('utf-8', 'ignore')
			else :
				var = t_efi_dump[nv_end_match + 0x31:nv_end_match + 0x41].decode('utf-8', 'ignore')
			
			if var[-2:] == "01" :
				t_nv_type = "GT21x"
			elif var[-2:] == "02" :
				t_nv_type = "GF10x"
			elif var[-2:] == "03" :
				t_nv_type = "GF119"
			elif var[-2:] == "04" :
				t_nv_type = "GK1xx"
			elif var[-2:] == "05" :
				t_nv_type = "GM1xx"
			elif var[-2:] == "06" :
				t_nv_type = "GM2xx"
			elif var[-2:] == "07" :
				t_nv_type = "GP1xx"
			else :
				t_nv_type = "GXnew"
			
			if var[:12] != "000000000000" :
				t_nv_type += "_Strange"
			
			if var[12:14] == "01" :
				t_nv_type += "_MXM"
			elif var[12:14] == "02" :
				t_nv_type += "_Multi-Display"
			elif var[12:14] == "03" :
				t_nv_type += "_GOP-Override"
			elif var[12:14] != "00" :
				t_nv_type += "_Custom"
						
			var = "0x" + var + " = " + t_nv_type
		else :
			if re.search(br'\x4D\x58\x4D\x5F', t_efi_dump) is not None : ## MXM_ or MXM_V (\x56|\x76)
				t_nv_type = "GXxxx_MXM"
				var = "missing = GXxxx_MXM"
			else :
				t_nv_type = "GXxxx"
				var = "missing"
			
			#var = "missing" if t_nv_type == "GXxxx" else "missing = GXxxx_MXM"
		
		print(Style.BRIGHT + Fore.GREEN + "Nvidia GOP" + Fore.WHITE + " %s  " % t_version + 
		Fore.GREEN + "Variant" + Fore.WHITE + " %s \n\n" % var + 
		Fore.GREEN + "Dated:" + Fore.WHITE + " %s  " % date + 
		Fore.GREEN + "Changelist" + Fore.WHITE + " %s" % chg + 
		Fore.RESET + Style.NORMAL)
		
		t_efi_info_string = t_nv_type + " - " + t_version + " - " + date + " - " + chg
		
		return (t_gop_type, t_nv_type, t_version, t_efi_info_string)
	
	## Nvidia GOP older versions
	
	pat_nv = re.compile(br'\xD6\xDC\x9B\xE1\xDF\xA6\xE4\x4F\xB7\x53\xD6\x77\xC7\x24\x8B\x77\x70\x21\x0A\xCC\x39\x0B\xD8\x45\xB4\x69\xD0\x4E\x57\xB5\x22\xB3\xEE\x27\xE5\xF5\x83\xA2\x27\x41\x9A\x2F\xAF\xFA\xBF\x26\xDF\x70') ## Part of a hash or something
	match_nv = pat_nv.search(t_efi_dump)
	
	if match_nv is not None :
		
		(nv_start_match, nv_end_match) = match_nv.span()
		t_gop_type = "Nvidia"
		
		test_ver1  = int.from_bytes(t_efi_dump[nv_start_match - 0x18:nv_start_match - 0x14], 'little')
		test_ver2  = int.from_bytes(t_efi_dump[nv_start_match + 0x108:nv_start_match + 0x10C], 'little')
		
		if 0x10000 <= test_ver2 <= 0x100017 :
			t_version = "0x%0.5X" % test_ver2
		elif 0x10000 <= test_ver1 <= 0x100017 :
			t_version = "0x%0.5X" % test_ver1
		else :
			t_version = "unknown"
		
		if re.search(br'\x4D\x58\x4D\x5F', t_efi_dump) is not None : ## MXM_ or MXM_V (\x56|\x76)
			t_nv_type = "GXxxx_MXM"
			var = "missing = GXxxx_MXM"
		else :
			t_nv_type = "GXxxx"
			var = "missing"
		
		date = "missing"
		chg  = "missing"
		
		print(Style.BRIGHT + Fore.GREEN + "Nvidia GOP" + Fore.WHITE + " %s  " % t_version + 
		Fore.GREEN + "Variant" + Fore.WHITE + " %s \n\n" % var + 
		Fore.GREEN + "Dated:" + Fore.WHITE + " %s  " % date + 
		Fore.GREEN + "Changelist" + Fore.WHITE + " %s" % chg + 
		Fore.RESET + Style.NORMAL)
		
		t_efi_info_string = t_nv_type + " - " + t_version + " - " + date + " - " + chg
		
		return (t_gop_type, t_nv_type, t_version, t_efi_info_string)
	
	## Mac AMD
	pat_mac_ati = re.compile(br'\x41\x00\x54\x00\x49\x00\x20\x00\x52\x00\x61\x00\x64\x00\x65\x00\x6F\x00\x6E\x00\x20\x00\x55\x00\x47\x00\x41\x00\x20\x00\x44\x00\x72\x00\x69\x00\x76\x00\x65\x00\x72\x00') ## A.T.I. .R.a.d.e.o.n. .U.G.A. .D.r.i.v.e.r.
	pat_mac_amd = re.compile(br'\x41\x00\x4D\x00\x44\x00\x20\x00\x52\x00\x61\x00\x64\x00\x65\x00\x6F\x00\x6E\x00\x20\x00\x44\x00\x72\x00\x69\x00\x76\x00\x65\x00\x72\x00')
	# A.M.D. .R.a.d.e.o.n. .D.r.i.v.e.r.
	
	match_mac_amd = pat_mac_ati.search(t_efi_dump)
	
	if match_mac_amd is None :
		match_mac_amd = pat_mac_amd.search(t_efi_dump)
		
	if match_mac_amd is not None :
		(mac_start_match, mac_end_match) = match_mac_amd.span()
		t_gop_type = "Mac_AMD"
		t_version  = t_efi_dump[mac_end_match + 2:mac_end_match + 0x14].decode('utf-16', 'ignore')
		
		pat_mac_date = re.compile(br'\x45\x00\x46\x00\x49\x00\x43\x00\x6F\x00\x6D\x00\x70\x00\x69\x00\x6C\x00\x65\x00\x44\x00\x61\x00\x74\x00\x65\x00')
		match_mac_date = pat_mac_date.search(t_efi_dump)
		
		if match_mac_date is not None :
			(date_start_match, date_end_match) = match_mac_date.span()
			date = t_efi_dump[date_start_match - 0x18:date_start_match - 0xD].decode('utf-8', 'ignore')
			
			if date[:3].isnumeric() :
				date = t_efi_dump[date_end_match + 4:date_end_match + 0xF].decode('utf-8', 'ignore')
		
		else :
			date = "not found"
		
		print(Style.BRIGHT + Fore.RED + "Mac AMD GOP" + Fore.WHITE + " %s  " % t_version + Fore.RED + "Dated:" + 
		Fore.WHITE + " %s  " % date + Fore.RESET + Style.NORMAL)
		
		pat_mac_ver = re.compile(br'\x41(\x54|\x4D)(\x49|\x44)\x20\x52\x61\x64\x65\x6F\x6E\x20\x48\x44\x20') # ATI|AMD Radeon HD
		match_mac_ver = pat_mac_ver.search(t_efi_dump)
		
		if match_mac_ver is not None :
			(mac_start_ver, mac_end_ver) = match_mac_ver.span()
			ver_list = " ## "
			step     = mac_start_ver
			ver_char = t_efi_dump[step:step + 1]
			
			while True :
				ver_item = ""
				
				while ver_char != b'\x00' :
					ver_item += ver_char.decode('utf-8', 'ignore')
					step     += 1
					ver_char = t_efi_dump[step:step + 1]
				
				if len(ver_item) < 3:
					break
				
				ver_list += ver_item + " ## "
								
				while ver_char == b'\x00' :
					step     += 1
					ver_char = t_efi_dump[step:step + 1]
		
		print(Style.BRIGHT + Fore.RED + "\nDetails:" + Fore.WHITE + "%s" % ver_list + Fore.RESET + Style.NORMAL)	
		
		return (t_gop_type, "", t_version, "")
	
	## Mac Nvidia
	
	#pat_mac_nv = re.compile(br'\x4E\x00\x56\x00\x49\x00\x44\x00\x49\x00\x41\x00\x20\x00\x47\x00\x50\x00\x55\x00\x20\x00')
	##\x55\x00\x45\x00\x46\x00\x49\x00\x20\x00\x44\x00\x72\x00\x69\x00\x76\x00\x65\x00\x72\x00') ## N.V.I.D.I.A. .G.P.U. .U.E.F.I. .D.r.i.v.e.r. - False positives with normal Nvidia GOP
	#match_mac_nv = pat_mac_nv.search(t_efi_dump)
	
	# NVDA,NVMac
	# AAPL,EMC-Display-List
	# AAPL,boot-display
	# AAPL,backlight-control
	# APPLE
	# APPLE_SRC_DPCD_ACCESS
	# MacVidCards
	
	if re.search(b'NVDA,NVMac', t_efi_dump) is not None :
		match_mac_nv = True
	elif re.search(br'\x41\x00\x41\x00\x50\x00\x4C\x00\x2C\x00', t_efi_dump) is not None : # A.A.P.L.,.
		match_mac_nv = True
	elif re.search(br'\x41\x00\x50\x00\x50\x00\x4C\x00\x45\x00', t_efi_dump) is not None : # A.P.P.L.E.
		match_mac_nv = True
	else :
		match_mac_nv = False
	
	#if match_mac_nv is not None :
		#(mac_start_match, mac_end_match) = match_mac_nv.span()
	if match_mac_nv :
		t_gop_type = "Mac_Nvidia"
		pat_mac_ver = re.compile(br'\x4E\x56\x44\x41\x2D\x45\x46\x49\x2D\x42\x75\x69\x6C\x64\x2D\x49\x6E\x66\x6F')
		match_mac_ver = pat_mac_ver.search(t_efi_dump)
		
		if match_mac_ver is not None :
			(mac_start_ver, mac_end_ver) = match_mac_ver.span()
			t_version = t_efi_dump[mac_end_ver:mac_end_ver + 0x13].decode('utf-8', 'ignore').replace("-", " ").strip()
		else :
			t_version = "unknown"
		
		if re.search(br'\x4D\x58\x4D\x5F', t_efi_dump) is not None : ## MXM_
			t_version += "_MXM"
		
		print(Style.BRIGHT + Fore.GREEN + "Mac Nvidia GOP" + Fore.WHITE + " %s  " % t_version + Fore.RESET + Style.NORMAL)
		
		return (t_gop_type, "", t_version, "")
	
	
	## LSI MPT UEFI
	## Added only for extraction purpose
	pat_lsi   = re.compile(br'\x4C\x53\x49\x20\x53\x41\x53(\x32|\x33)\x20\x4D\x50\x54\x20\x55\x45\x46\x49') ## LSI SASx MPT UEFI
	match_lsi = pat_lsi.search(t_efi_dump)
	
	if match_lsi is not None :
		t_gop_type = "LSI SASx MPT UEFI"
		(lsi_start_match, lsi_end_match) = match_lsi.span()
		sas_type  = t_efi_dump[lsi_start_match + 7:lsi_start_match + 8].decode('utf-8', 'ignore')
		t_gop_type = "LSI SAS%s MPT UEFI" % sas_type
		pat_ver   = re.compile(br'\x4C\x53\x49\x20\x43\x6F\x72\x70\x6F\x72\x61\x74\x69\x6F\x6E\x0A\x76') ## LSI Corporation.v
		match_ver = pat_ver.search(t_efi_dump, lsi_end_match)
		
		if match_ver is None :
			pat_ver   = re.compile(br'\x41\x76\x61\x67\x6F\x20\x54\x65\x63\x68\x6E\x6F\x6C\x6F\x67\x69\x65\x73\x2E\x20\x41\x6C\x6C\x20\x72\x69\x67\x68\x74\x73\x20\x72\x65\x73\x65\x72\x76\x65\x64\x2E\x0A\x76') ## Avago Technologies. All rights reserved..v
			match_ver = pat_ver.search(t_efi_dump, lsi_end_match)
		
		if match_ver is not None :
			(ver_start_match, ver_end_match) = match_ver.span()
			step = ver_end_match
			
			while t_efi_dump[step:step + 1] != b'\x0A' :
				step += 1
			
			t_version = t_efi_dump[ver_end_match:step].decode('utf-8', 'ignore').strip()
			print("LSI SAS%s MPT UEFI %s" % (sas_type, t_version))
			
			try :
				cut_ver   = t_version.index("*")
				t_version = t_version[:cut_ver].strip()
			except :
				pass
			
		return (t_gop_type, "", t_version, "")
	
	print(Style.BRIGHT + Fore.CYAN + "\nEFI ROM is present, but is not standard GOP type." + Fore.RESET + Style.NORMAL)
	
	return ("Unknown", "", "unknown", "")

def nvidia_board() :
	hint_message = "Missing"
	
	pat_nv   = re.compile(br'\x4E\x56\x49\x44\x49\x41\x20\x43\x6F\x72\x70\x2E\x0D\x0A') ## NVIDIA Corp...
	match_nv = pat_nv.search(reading)
	
	if match_nv is not None :
		(nv_start_match, nv_end_match) = match_nv.span()
		
		if reading[nv_end_match:nv_end_match + 0xB] == b'\x00\x00\x00\xFF\xFF\x00\x00\x00\x00\xFF\xFF' :
			#print("Normal string")
			hint_bgn = nv_end_match + 0xB
		else :
			#print("Different string")
			hint_bgn  = nv_end_match
			skip_byte = reading[hint_bgn:hint_bgn + 1]
			
			while skip_byte == b'\x00' or skip_byte == b'\xFF' :
				hint_bgn  += 1
				skip_byte = reading[hint_bgn:hint_bgn + 1]
		
		hint_message = ""
		hint_step    = hint_bgn
		hint_char    = reading[hint_step:hint_step + 1]
		
		while hint_char != b'\x00' and hint_char != b'\xFF' and hint_char != b'\x2D' :
			hint_message += hint_char.decode('utf-8', 'ignore')
			hint_step    += 1
			hint_char    = reading[hint_step:hint_step + 1]
	
	return hint_message.strip()

def is_version_upd(t_last_gop, t_version, t_gop_type) :
	
	if t_gop_type == "AMD" :
		t_lastgop_int = int(t_last_gop[2:4])
		t_version_int = int(t_version[2:4].strip("."))
	elif t_gop_type == "Nvidia" :
		t_lastgop_int = int(t_last_gop, 16)
		t_version_int = int(t_version, 16)
	
	if t_version == t_last_gop :
		print("You already have the latest available GOP!\n")
		sys.exit()
	elif t_version_int < t_lastgop_int :
		print("Latest available GOP is %s\n" % t_last_gop)
	else :
		print(Style.BRIGHT + Fore.YELLOW + "You have a newer version! Please report it in the forum!\n" + Fore.RESET + Style.NORMAL)
		sys.exit()
	
	return None

def remove_padding(t_end_data, t_end_img_old, t_end_img_new, t_all_size, t_str_err) :
	bgn_extra = 0
	
	for padd_off in range (t_end_img_old, t_all_size) :
		padd_byte = reading[padd_off:padd_off + 1]
		
		if padd_byte == b'' :
			break
		
		elif padd_byte != b'\xFF' and padd_byte != b'\x00' :
			bgn_extra = padd_off
			print(Style.BRIGHT + Fore.RED + t_str_err + Fore.RESET)
			#t_end_data = reading[t_end_img_old:]
			break
	
	## If there is extra data after ROM images.
	if bgn_extra :
		## If the extra data offset is now inside the new image.
		
		if bgn_extra < t_end_img_new :
			print(Style.BRIGHT + Fore.RED + "  Unable to recover extra data at the same offset 0x%0.2X! Please report it!\n" % bgn_extra + 
			Fore.RESET + Style.NORMAL)
			t_end_data = reading[t_end_img_old:]
		
		## Extra data can be recovered at the old offset
		else :
			print(Style.BRIGHT + Fore.YELLOW + "  Recovering extra data at the same offset 0x%0.2X.\n" % bgn_extra + 
			Fore.RESET + Style.NORMAL)
			## If the new image ends after the old one, just copy from there.
			
			if t_end_img_new > t_end_img_old :
				t_end_data = reading[t_end_img_new:]
			
			## But if the old image was bigger, we need to fill the difference with padding and then copy from the end of old image.
			else :
				t_end_data = b'\xFF' * (t_end_img_old - t_end_img_new) + reading[t_end_img_old:]
	
	return t_end_data

def check_in_database(t_efi_info_string) :
	efi_in_db     = False
	#unknown_type = False
	
	#if t_efi_info_string == "" :
	#	return None
	
	if nv_type == "GXxxx" or nv_type == "GXxxx_MXM" :
		unknown_type = True
		index        = len(nv_type) + 3
	else :
		unknown_type = False
		index        = 0
	
	with open("#GOP_Files\\#GOP_Database.txt", 'r+') as db_file:
		for line in db_file:
			
			if len(line) < 2 or line[:2] == "##" :
				continue
			
			elif line[index:] == t_efi_info_string[index:] :
				efi_in_db = True
				
				if unknown_type :
					new_type = line[:index - 3]
				
				#print("EFI %s is present in the database!\n" % t_efi_info_string)
				break
	
	if efi_in_db :
		
		if unknown_type :
			return new_type, True
		else :
			return None, True

	else :
		print(Style.BRIGHT + Fore.YELLOW + "Note: The GOP file is not present in my database.\n\n      You can help me by reporting it.\n" + 
		Fore.RESET + Style.NORMAL)
		
		return None, False

####################################
####################################
####################################

if len(sys.argv) < 3 :
	print(Fore.RED + "Not enough arguments! Usage: GOPupd.py file.rom [ext_efirom | gop_upd]" + Fore.RESET)
	sys.exit()
else :
	file_dir = sys.argv[1]
	file_rom = os.path.basename(file_dir)
	file_arg = sys.argv[2]

if not os.path.isfile(file_dir) :
	print(Fore.RED + "File %s was not found!" % file_dir + Fore.RESET)
	sys.exit()

try :
	f = open(file_dir, 'rb')
	reading = f.read()
	f.close()
except :
	print(Fore.RED + "Unable to open file %s for reading!" % file_dir + Fore.RESET)
	sys.exit()

fileName, fileExtension = os.path.splitext(file_rom)
position = 0

if file_arg == "ext_efirom" :
	## Get ROM info for EFI extraction
	efi_found, efi_begin, efi_size = rom_info("mini")
	
	if not efi_found :
		print(Fore.RED + "No EFI ROM found!\n" + Fore.RESET)
		#f.close()
		sys.exit()
	
	efi_rom  = reading[efi_begin:efi_begin + efi_size]
	
	with open("%s_temp\\%s_compr.efirom" % (file_rom, fileName), 'wb') as efi_rom_file :
		efi_rom_file.write(efi_rom)
	#f.close()
	sys.exit()
	
elif file_arg == "gop_upd" :

	gop_type = ""
	file_efi = "%s_temp\\%s_dump.efi" % (file_rom, fileName)
	file_efr = "%s_temp\\%s_compr.efirom" % (file_rom, fileName)
	
	if os.path.isfile(file_efi) :
		with open(file_efi, "rb") as myfile :
			efi_dump = myfile.read()
		
		## Get EFI info
		gop_type, nv_type, version, efi_info_string = efi_version(efi_dump)
		
		## The machine code type, signer and CRC32 are processed outside efi_version because they are not bound to GOP.
		
		## Signer
		## Needs a full X.509 parser. Since it is not that important, only get the first signer.
		pe_off     = int.from_bytes(efi_dump[0x3C:0x40], 'little')
		code_size  = int.from_bytes(efi_dump[pe_off + 0x50:pe_off + 0x54], 'little') ## only works for EFI files, not for every exe.
		pat_sign   = re.compile(br'\x06\x09\x2A\x86\x48\x86\xF7\x0D\x01\x07\x02')
		match_sign = pat_sign.search(efi_dump, code_size)
		
		if match_sign is not None :
			(sign_start_match, sign_end_match) = match_sign.span()
			#print("\nEFI Image is signed!")
			efi_is_signed = "Signed"
			pat_signer    = re.compile(br'\x06\x03\x55\x04\x03\x13') ## 06 03 55 04 03 13
			match_signer  = pat_signer.search(efi_dump, sign_end_match)
			
			if match_signer is not None :
				(signer_start_match, signer_end_match) = match_signer.span()
				mess_len = ord(efi_dump[signer_end_match:signer_end_match + 1])
				signer   = efi_dump[signer_end_match + 1:signer_end_match + mess_len + 1].decode('utf-8', 'ignore')
				print(Style.BRIGHT + Fore.CYAN + "\nMost likely signed by: %s\n" % signer + Fore.RESET + Style.NORMAL)
			else :
				print(Style.BRIGHT + Fore.CYAN + "\nEFI Image is signed!\n" + Fore.RESET + Style.NORMAL)
		
		else :
			efi_is_signed = "Unsigned"
			print(Style.BRIGHT + Fore.CYAN + "\nEFI image is NOT signed!\n" + Fore.RESET + Style.NORMAL)
		
		if gop_type == "AMD" :
			efi_info_string += " - " + "%s" % efi_is_signed
		
		## Machine Code Type
		#pe_off  = int.from_bytes(efi_dump[0x3C:0x40], 'little')
		pe_test = binascii.hexlify(efi_dump[pe_off:pe_off + 4]).decode('utf-8').upper()
		
		if pe_test == "50450000" :
			code = binascii.hexlify(efi_dump[pe_off + 4:pe_off + 6][::-1]).decode('utf-8').upper()
			
			if code == "014C" :
				codetype = "IA32"
			elif code == "0200" :
				codetype = "IA64"
			elif code == "8664" :
				codetype = "x64"
			elif code == "0EBC" :
				codetype = "EFI Byte Code"
			elif code == "01C0" :
				codetype = "ARM"
			elif code == "01C2" :
				codetype = "ARM-THUMB-MIXED"
			elif code == "01C4" :
				codetype = "ARMv7"
			else :
				codetype = "unknown (%s)" % code
			
			print(Style.BRIGHT + Fore.CYAN + "Machine Code   = %s\n" % codetype + Fore.RESET + Style.NORMAL)
		
		## CRC32
		#efi_crc32 = get_crc32(efi_dump)
		efi_crc32_int = binascii.crc32(efi_dump) & 0xFFFFFFFF
		efi_crc32_hex = "%08X" % efi_crc32_int
		print(Style.BRIGHT + Fore.CYAN + "Checksum CRC32 = %s\n" % efi_crc32_hex + Fore.RESET + Style.NORMAL)
		
		## Check in database
		if efi_info_string != "" :
						
			efi_info_string += " - " + "%s\n" % efi_crc32_hex
			
			#print(efi_info_string)
			#with open("#add_new_string.txt", "a") as myfile :
			#	myfile.write(efi_info_string)
			
			new_nv_type, efi_in_db = check_in_database(efi_info_string)
			
			if new_nv_type is not None :
				nv_type = new_nv_type
				#print("GOP identified as %s based on CRC\n" % nv_type)
				print(Style.BRIGHT + Fore.WHITE + "GOP identified as" + Fore.GREEN + " %s " % nv_type + 
				Fore.WHITE + "based on CRC \n" + Fore.RESET + Style.NORMAL)
		
		## Rename temp files
		
		## For you
		gop_version  = "%s %s" % (nv_type, version) if nv_type != "" else version
		file_new_bgn = "%s_temp\\%s GOP %s" % (file_rom, gop_type, gop_version)
		
		## For me
		#version_me      = version[2:] if version[:2] == "0x" else version
		#gop_version_me  = "%s %s" % (nv_type, version_me) if nv_type != "" else version_me
		#file_new_bgn    = "%s_temp\\%s GOP %s %s" % (file_rom, gop_type, gop_version_me, fileName)
		
		## And nothing for the rest.
		
		file_new_efr = "%s_compr.efirom" % file_new_bgn
		file_new_efi = "%s_dump.efi" % file_new_bgn
		
		if os.path.exists(file_new_efi) :
			os.remove(file_new_efi)
		if os.path.exists(file_new_efr) :
			os.remove(file_new_efr)
			
		try :
			os.rename(file_efi, file_new_efi)
		except :
			print("Error on renaming temp files!\n")
		
		try :
			os.rename(file_efr, file_new_efr)
		except :
			print("Error on renaming temp files!\n")
		
		if gop_type not in ['AMD', 'Nvidia'] or not efi_in_db :
			#if efi_info_string != "" :
			#	with open("#add_new_string.txt", "a") as myfile :
			#		myfile.write(efi_info_string)
			src_dir = "%s_temp" % file_rom
			dst_dir = "%s_newGOP" % file_rom
			os.rename(src_dir, dst_dir)
		
	print(Fore.RED + "---------------------------------------------------------------\n" + Fore.RESET)
	
	print(Fore.GREEN + "***************************************************************")
	print("***                Processing with Python...                ***")
	print("*************************************************************** \n" + Fore.RESET)
	#print("---------------------------------------------------------------\n\n")
	
	last_amd_new  = "1.60.0.15.50"
	last_amd_old  = "1.57.0.0.0"
	last_nv_GT21x = "0x1002E"
	last_nv_GF10x = "0x1001F"
	last_nv_GF119 = "0x10030"
	last_nv_GK1xx = "0x10034"
	last_nv_GM1xx = "0x10034"
	last_nv_GM2xx = "0x2000E"
	last_nv_GP1xx = "0"
	
	last_nv_GK1xx_MXM = "0x10033"
	last_nv_GM1xx_MXM = "0x10034"
	last_nv_GK1xx_MDP = "0x10030"
	
	## GOP Test
	if gop_type == "AMD" :
		last_gop = last_amd_new
		is_version_upd(last_gop, version, gop_type)
	
	elif gop_type == "Nvidia" :
		if len(nv_type) > 12 and nv_type[6:13] == "Strange" : # GXxyz_Strange or GXxyz_Strange_[MXM|Multi-Display|Custom]
			print(Style.BRIGHT + Fore.YELLOW + "You have a strange GOP! Please report it!\n" + Fore.RESET + Style.NORMAL)
			#f.close()
			sys.exit()
		elif len(nv_type) > 6 and nv_type[-6:] == "Custom" : # GXxyz[_Strange]_Custom
			print(Style.BRIGHT + Fore.YELLOW + "You have a custom GOP! Currently not supported. Please report it!\n" + Fore.RESET + Style.NORMAL)
			#f.close()
			sys.exit()
		elif nv_type == "GT21x" :
			last_gop = last_nv_GT21x
			nv_file  = "nv_gop_GT21x.efirom"
			is_version_upd(last_gop, version, gop_type)
		elif nv_type == "GF10x" :
			last_gop = last_nv_GF10x
			nv_file  = "nv_gop_GF10x.efirom"
			is_version_upd(last_gop, version, gop_type)
		elif nv_type == "GF119" :
			last_gop = last_nv_GF119
			nv_file  = "nv_gop_GF119.efirom"
			is_version_upd(last_gop, version, gop_type)
		elif nv_type == "GK1xx" :
			last_gop = last_nv_GK1xx
			nv_file  = "nv_gop_GK1xx.efirom"
			is_version_upd(last_gop, version, gop_type)
		elif nv_type == "GM1xx" :
			last_gop = last_nv_GM1xx
			nv_file  = "nv_gop_GM1xx.efirom"
			is_version_upd(last_gop, version, gop_type)
		elif nv_type == "GM2xx" :
			last_gop = last_nv_GM2xx
			nv_file  = "nv_gop_GM2xx.efirom"
			is_version_upd(last_gop, version, gop_type)
		elif nv_type == "GK1xx_MXM" :
			last_gop = last_nv_GK1xx_MXM
			nv_file  = "nv_gop_GK1xx_MXM.efirom"
			is_version_upd(last_gop, version, gop_type)
		elif nv_type == "GM1xx_MXM" :
			last_gop = last_nv_GM1xx_MXM
			nv_file  = "nv_gop_GM1xx_MXM.efirom"
			is_version_upd(last_gop, version, gop_type)
		elif nv_type == "GK1xx_Multi-Display" :
			last_gop = last_nv_GK1xx_MDP
			nv_file  = "nv_gop_GK1xx_multi.efirom"
			is_version_upd(last_gop, version, gop_type)
		elif len(nv_type) > 3 and nv_type[-3:] == "MXM" : # GXxyz_MXM or GXxxx_MXM
			print(Style.BRIGHT + Fore.YELLOW + "You have an unsupported MXM GPU! Please report it! \n" + Fore.RESET + Style.NORMAL)
			#f.close()
			sys.exit()
		elif len(nv_type) > 13 and nv_type[-13:] == "Multi-Display" : # GXxyz_Multi-Display
			print(Style.BRIGHT + Fore.YELLOW + "You have an unsupported Multi-Display GPU! Please report it!\n" + Fore.RESET + Style.NORMAL)
			#f.close()
			sys.exit()
		elif nv_type != "GXxxx" : # GXnew
			print(Style.BRIGHT + Fore.YELLOW + "You have a new GOP type! Please report it!\n" + Fore.RESET + Style.NORMAL)
			#f.close()
			sys.exit()
		else : # == GXxxx i.e. no variant ID.
			last_gop = "latest available"
			print(Style.BRIGHT + Fore.YELLOW + "Unable to determine GOP type!\n" + Fore.RESET + Style.NORMAL)
	
	elif gop_type[:4] == "Mac_" :
		print(Style.BRIGHT + Fore.RED + "Mac GOP support is limited! Drop your compressed GOP as mac_gop.efirom in #GOP_Files\n" + 
		Fore.RESET + Style.NORMAL)
		last_gop = "your file"
		mac_file  = "mac_gop.efirom"
		#sys.exit()
	elif gop_type[:3] == "LSI" :
		print(Style.BRIGHT + Fore.RED + "LSI SASx MPT UEFI not supported!\n" + Fore.RESET + Style.NORMAL)
		sys.exit()
	elif gop_type == "Unknown" :
		print(Style.BRIGHT + Fore.RED + "Not GOP or GOP is not common type! Please report it!\n" + Fore.RESET + Style.NORMAL)
		sys.exit()
	else :
		last_gop = "latest available"
		print(Style.BRIGHT + Fore.RED + "GOP is not present!!!\n" + Fore.RESET + Style.NORMAL)
	
	## Get ROM Info
	orom_old_type, orom_start, orom_pcir_off, orom_id_bin, orom_id_hex, orom_size, efi_found, efi_begin, efi_size = rom_info("all")
	#orom_id_hex = binascii.hexlify(orom_id_bin[::-1]).decode('utf-8').upper()
	ven_dev = "%s-%s" % (orom_id_hex[4:], orom_id_hex[:4])
	pci_ven = ven_dev[:4]
	pci_dev = ven_dev[-4:]
	#print(ven_dev)
	#print("%0.2X = %s-%s = %0.2X" % (orom_start, pci_ven, ven_dev[-4:], orom_last_img))
	#print(Style.BRIGHT + Fore.CYAN + "%s = ID of ROM file\n" % ven_dev + Fore.RESET + Style.NORMAL)
	
	
	## Check that EFI ROM header is a good match
	
	if orom_start == efi_begin :
		print(Style.BRIGHT + Fore.CYAN + "It appears you used an EFI ROM! Only extraction is possible." + Fore.RESET + Style.NORMAL)
		#f.close()
		sys.exit()
	elif pci_ven not in ['1002', '10DE'] :
		print(Style.BRIGHT + Fore.YELLOW + "Only AMD and Nvidia GOP supported!" + Fore.RESET + Style.NORMAL)
		#f.close()
		sys.exit()
	elif efi_found :
		if os.path.isfile(file_efi) and codetype != "x64" and gop_type[:4] != "Mac_" :
			print(Style.BRIGHT + Fore.YELLOW + "Code type %s is not supported!" % codetype + Fore.RESET + Style.NORMAL)
			#f.close()
			sys.exit()
		
		efi_pcir_ds    = int.from_bytes(reading[efi_begin + 0x18:efi_begin + 0x1A], 'little')
		efi_pcir_off   = efi_begin + efi_pcir_ds
		efi_class_code = binascii.hexlify(reading[efi_pcir_off + 0xD:efi_pcir_off + 0x10]).decode('utf-8')
		efi_code_type  = reading[efi_pcir_off + 0x14:efi_pcir_off + 0x15]
		efi_last_img   = ord(reading[efi_pcir_off + 0x15:efi_pcir_off + 0x16]) & 0x80
		
		if efi_class_code not in ['030000', '000003'] and gop_type[:4] != "Mac_" :
			print(Style.BRIGHT + Fore.YELLOW + "Class-code %s is not supported!" % efi_class_code + Fore.RESET + Style.NORMAL)
			#f.close()
			sys.exit()
		if efi_code_type != b'\x03' :
			print(Style.BRIGHT + Fore.RED + "Code mismatch in EFI ROM header!" + Fore.RESET + Style.NORMAL)
			#f.close()
			sys.exit()
		if not efi_last_img :
			print(Style.BRIGHT + Fore.RED + "EFI ROM is not last image! Please report it!" + Fore.RESET + Style.NORMAL)
			#f.close()
			sys.exit()
	
	## Pretty please
	ask = input("\nDo you want to update GOP to %s? Y for yes or N for no: " % last_gop)
	if ask.upper() != "Y" :
		#f.close()
		sys.exit()
	print("")
	
	## GRID K1/K2 check
	if pci_ven == "10DE" and pci_dev in ['0FF2', '11BF'] :
		gop_type = "Nvidia"
		nv_type  = "GK1xx_Multi-Display"
		nv_file  = "nv_gop_GK1xx_multi.efirom"
		last_gop = last_nv_GK1xx_MDP
		print(Style.BRIGHT + Fore.YELLOW + "  Using Multi-Display GOP %s for GRID K1/K2.\n" % last_nv_GK1xx_MDP + Fore.RESET + Style.NORMAL)
	
	## Get the right GOP
	if gop_type == "AMD" or (pci_ven == "1002" and gop_type == "") :
		## The next two lines are needed for the case of missing GOP.
		gop_type   = "AMD"
		last_gop   = last_amd_new
		efi_id_off = 0x20 ## might change it future versions
		id_in_gop  = False
		
		## GOP 1.59.0.0.0 (and newer) has less IDs than 1.57.0.0.0, a double check is needed.
		with open("#GOP_Files\\amd_gop_IDs.txt", 'r+') as id_file:
			for line in id_file:
				if line[:9] == ven_dev :
					id_in_gop = True
					#print("The ID %s is present in the GOP!\n" % ven_dev)
					break
		
		if id_in_gop :
			amd_file = "amd_gop.efirom"
		else :
			print(Style.BRIGHT + Fore.YELLOW + "  Warning! Your VBIOS ID %s doesn't exist in latest available GOP!\n" % ven_dev + 
			Fore.RESET + Style.NORMAL)
			ask = input("\nDo you still want to update GOP? Y for yes or any key for checking the ID in older 1.57.0.0.0 GOP: ")
			
			if ask.strip().upper() == "Y" :
				amd_file = "amd_gop.efirom"
				print("")
			else :
				with open("#GOP_Files\\amd_gop_IDs_1.57.0.0.0.txt", 'r+') as id_file:
					for line in id_file:
						if line[:9] == ven_dev :
							id_in_gop = True
							#print("The ID %s is present in the GOP!\n" % ven_dev)
							break
				print("")
				
				if id_in_gop :
					last_gop = last_amd_old ## This is only to have the proper updated version displayed.
					amd_file = "amd_gop_1.57.0.0.0.efirom"
				else :
					print(Style.BRIGHT + Fore.YELLOW + "  Warning! Your VBIOS ID %s doesn't exist in older GOP!\n" % ven_dev + 
					Fore.RESET + Style.NORMAL)
					ask = input("\nDo you still want to update GOP? A for %s, B for 1.57.0.0.0 or any key for exit: " % last_amd_new)
					ask = ask.strip().upper()
					
					if ask == "A" :
						amd_file = "amd_gop.efirom"
					elif ask == "B" :
						last_gop = last_amd_old ## This is only to have the proper updated version displayed.
						amd_file = "amd_gop_1.57.0.0.0.efirom"
					else :
						#f.close()
						sys.exit()
					
					print("")
		
		with open("#GOP_Files\\%s" % amd_file, 'rb') as amd_gop :
			gop_rom = amd_gop.read()
		
	elif gop_type == "Nvidia" and nv_type != "GXxxx" :
		
		#gop_type = "Nvidia"
		efi_id_off  = 0x20 ## might change it future versions
		efr_lst_off = 0x31 ## might change it future versions
		efi_lst_off = 0x4A ## might change it future versions
		
		## Make sure the Nvidia GOP is not customized. Only the last digit of variant ID should be non-zero.
		try :
			with open("#GOP_Files\\%s" % nv_file, 'rb') as nv_gop :
				gop_rom = nv_gop.read()
		except :
			print(Style.BRIGHT + Fore.RED + "  Unable to find a matching GOP! Please report it!\n" + 
			Fore.RESET + Style.NORMAL)
			sys.exit()
	
	elif pci_ven == "10DE" and (gop_type == "" or gop_type == "Nvidia") :
		
		gop_type = "Nvidia"
		efi_id_off  = 0x20 ## might change it future versions
		efr_lst_off = 0x31 ## might change it future versions
		efi_lst_off = 0x4A ## might change it future versions
		
		print(Style.BRIGHT + Fore.YELLOW + "  Warning! GOP type missing! Continue only if you know what you are doing!\n" + 
		Fore.RESET + Style.NORMAL)
		
		gpu_hint = nvidia_board()
		
		print(Style.BRIGHT + Fore.YELLOW + "  Product name = %s. This might (!!) be used to determine your GPU architecture.\n" % gpu_hint + 
		Fore.RESET + Style.NORMAL)
		
		print("\nDo you still want to update GOP? Select the number of your GPU architecture: \n\n  1 = GT21x \n  2 = GF10x \
		\n  3 = GF119 \n  4 = GK1xx \n  5 = GM1xx \n  6 = GM2xx \n  7 = GK1xx_MXM \n  8 = GM1xx_MXM ")
		
		while True :
			ask = input("\n\nEnter choice: ")
			ask = ask.strip()
			
			if ask == "1" :
				last_gop = last_nv_GT21x
				nv_file = "nv_gop_GT21x.efirom"
				break
			elif ask == "2" :
				last_gop = last_nv_GF10x
				nv_file = "nv_gop_GF10x.efirom"
				break
			elif ask == "3" :
				last_gop = last_nv_GF119
				nv_file = "nv_gop_GF119.efirom"
				break
			elif ask == "4" :
				last_gop = last_nv_GK1xx
				nv_file = "nv_gop_GK1xx.efirom"
				break
			elif ask == "5" :
				last_gop = last_nv_GM1xx
				nv_file = "nv_gop_GM1xx.efirom"
				break
			elif ask == "6" :
				last_gop = last_nv_GM2xx
				nv_file = "nv_gop_GM2xx.efirom"
				break
			elif ask == "7" :
				last_gop = last_nv_GK1xx_MXM
				nv_file  = "nv_gop_GK1xx_MXM.efirom"
				break
			elif ask == "8" :
				last_gop = last_nv_GM1xx_MXM
				nv_file  = "nv_gop_GM1xx_MXM.efirom"
				break
			else :
				print("\nWrong choice! Self destruct in 10, 9, 8, ...")
				#f.close()
				#sys.exit()
		
		print("")
		
		with open("#GOP_Files\\%s" % nv_file, 'rb') as nv_gop :
			gop_rom = nv_gop.read()
	
	elif gop_type[:4] == "Mac_" :
		efi_id_off  = 0x20 ## Might not always be true
		efr_lst_off = 0x31 ## Might not always be true
		efi_lst_off = 0x4A ## Might not always be true
		
		if not os.path.isfile("#GOP_Files\\%s" % mac_file) :
			print(Fore.RED + "File %s was not found!" % mac_file + Fore.RESET)
			sys.exit()
		
		with open("#GOP_Files\\%s" % mac_file, 'rb') as mac_gop :
			gop_rom = mac_gop.read()
	else :
		print(Style.BRIGHT + Fore.YELLOW + "Only AMD and Nvidia GOP supported!" + Fore.RESET + Style.NORMAL)
		#f.close()
		sys.exit()
	
	orom_end      = orom_start + orom_size
	orom_pci_last = orom_pcir_off + 0x15
	orom_last_img = ord(reading[orom_pcir_off + 0x15:orom_pcir_off + 0x16]) & 0x80
	end_img_old   = orom_end + efi_size ## This is only [IFR + ] ROM + EFI, not all sections.
	end_img_new   = orom_end + len(gop_rom)
	all_size      = len(reading)
	weird_npds_ps = False
	
	## Check for special images between ROM and EFI, but not in first container. Don't know why Nvidia is doing this.
	if efi_found and efi_begin != orom_end : # Already checked for weird data in rom_info, must be special images in between
		end_img_old   = efi_begin + efi_size
		end_img_new   = efi_begin + len(gop_rom)
		weird_npds_ps = True
	
	## Fix first image for EFI pointing.
	if orom_last_img :
		
		print(Style.BRIGHT + Fore.YELLOW + "  Fixing last-image-bit in PCI Structure of Legacy ROM! \n" + Fore.RESET + Style.NORMAL)
		
		## Determine checksum byte
		if gop_type == "AMD" :
			imb_test = reading[orom_start + 0x1E:orom_start + 0x21].decode('utf-8', 'ignore')
			
			if imb_test == "IBM" :
				ibm_end = orom_start + 0x21
				chk_is_last = False
			else :
				ibm_sig = re.search(br'\x49\x42\x4D', reading[:0xD0])
				
				if ibm_sig is not None :
					(start_ibm, ibm_end) = ibm_sig.span()
					chk_is_last = False
					print(Style.BRIGHT + Fore.YELLOW + "  Checksum byte of Legacy OROM at offset 0x%0.2X! \n" % ibm_end + 
					Fore.RESET + Style.NORMAL)
				else :
					ibm_end = orom_end - 1
					chk_is_last = True
			
			chk_int_old = ord(reading[ibm_end:ibm_end + 1])
			chk_off     = ibm_end
		
		elif gop_type == "Nvidia" :
			chk_int_old = ord(reading[orom_end - 1:orom_end])
			chk_off     = orom_end - 1
			chk_is_last = True
		
		## Determine if there is one container for all ROMs. EFI is most likely missing.
		if reading[orom_pcir_off + 0x20:orom_pcir_off + 0x24] == b'NPDE' :
			npde_size = int.from_bytes(reading[orom_pcir_off + 0x28:orom_pcir_off + 0x2A], 'little') * 0x200
			
			if orom_size != npde_size :
				print(Style.BRIGHT + Fore.RED + "  Different sizes in PCI structure and NPDE structure of Legacy ROM!\n" + 
				Fore.RESET + Style.NORMAL)
				
				orom_end_npde = orom_start + npde_size
				rom_test_npde = binascii.hexlify(reading[orom_end_npde:orom_end_npde + 2]).decode('utf-8').upper()
				
				## If NPDE size is the right one, there is one container for all ROMs.
				if rom_test_npde in ['55AA', '564E'] :
					print(Style.BRIGHT + Fore.YELLOW + "  The Legacy ROM appears to be a container for all images.\n" + 
					Fore.RESET + Style.NORMAL)
					print(Style.BRIGHT + Fore.YELLOW + "  Fixing last-image-bit in last special image.\n" + Fore.RESET + Style.NORMAL)
					nv_step      = orom_end_npde
					check_nv_ext = reading[nv_step:nv_step + 2]
					
					while check_nv_ext == b'\x56\x4E' or check_nv_ext == b'\x55\xAA' :
						nv_ext_size = int.from_bytes(reading[nv_step + 2:nv_step + 4], 'little') * 0x200
						#print(nv_ext_size)
						
						if nv_ext_size == 0 :
							npds_off    = int.from_bytes(reading[nv_step + 0x18:nv_step + 0x1A], 'little')
							npds_off    += nv_step
							nv_ext_size = int.from_bytes(reading[npds_off + 0x10:npds_off + 0x12], 'little') * 0x200
							#print(nv_ext_size)
						
						nv_step      += nv_ext_size
						check_nv_ext = reading[nv_step:nv_step + 2]
					
					lst_img_npds_off = npds_off + 0x15
					lst_npds_int_old = ord(reading[lst_img_npds_off:lst_img_npds_off + 1])
					lst_npds_int_new = int(lst_npds_int_old & 0x7F)
					lst_npds_bin_new = bytes([lst_npds_int_new])
					
					checksum_old = sum(bytearray(reading[orom_start:orom_end_npde - 1]))
					checksum_new = (checksum_old - lst_npds_int_old + lst_npds_int_new) & 0xFF
					chk_int_new  = 256 - checksum_new if checksum_new else 0
					chk_bin_new  = bytes([chk_int_new])
					
					reading = reading[:orom_end_npde - 1] + chk_bin_new + reading[orom_end_npde:lst_img_npds_off] + \
							lst_npds_bin_new + reading[lst_img_npds_off + 1:]
					
					npde_off_test    = npds_off + 0x20
					lst_img_npde_off = npds_off + 0x2A
					
					if reading[npde_off_test:npde_off_test + 4] == b'NPDE' :
						lst_npde_int_old = ord(reading[lst_img_npde_off:lst_img_npde_off + 1])
						lst_npde_int_new = int(lst_npde_int_old & 0x7F)		
						lst_npde_bin_new = bytes([lst_npde_int_new])
						
						reading = reading[:lst_img_npde_off] + lst_npde_bin_new + reading[lst_img_npde_off + 1:]
		
		checksum_old = sum(bytearray(reading[orom_start:orom_end])) ## sumbytes(reading[orom_start:orom_end])
		
		lst_int_old  = ord(reading[orom_pci_last:orom_pci_last + 1])
		lst_int_new  = int(lst_int_old & 0x7F)
		lst_bin_new  = bytes([lst_int_new])
		
		checksum_new = (checksum_old - chk_int_old - lst_int_old + lst_int_new) & 0xFF
		
		chk_int_new  = 256 - checksum_new if checksum_new else 0
		chk_bin_new  = bytes([chk_int_new])
		
		if chk_is_last :
			print(Style.BRIGHT + Fore.YELLOW + "  Using last byte for checksum! \n" + Fore.RESET + Style.NORMAL)
			new_gop = reading[:orom_pci_last] + lst_bin_new + reading[orom_pci_last + 1:orom_end - 1] + chk_bin_new
		else :
			print(Style.BRIGHT + Fore.YELLOW + "  Using AMD byte for checksum! \n" + Fore.RESET + Style.NORMAL)
			new_gop = reading[:chk_off] + chk_bin_new + reading[chk_off + 1:orom_pci_last] + lst_bin_new + reading[orom_pci_last + 1:orom_end]
	else :
		new_gop = reading[:orom_end]
	
	## Add special images between ROM and EFI. If they are present and not part of main container, nothing else to do.
	## The last-bit is already set in ROM and special images.
	if weird_npds_ps :
		new_gop += reading[orom_end:efi_begin]
	
	## Assembly a new image
	if gop_type == "Nvidia" or gop_type == "Mac_Nvidia" :
		## Nvidia has special images and special structures, needs more care.
		efi_id_old   = sum(bytearray(gop_rom[efi_id_off:efi_id_off + 4]))
		efi_lst_old  = ord(gop_rom[efi_lst_off:efi_lst_off + 1]) #sum(bytearray(gop_rom[efi_lst_off:efi_lst_off + 1]))
		efr_lst_old  = ord(gop_rom[efr_lst_off:efr_lst_off + 1]) #sum(bytearray(gop_rom[efr_lst_off:efr_lst_off + 1]))
		checksum_old = sum(bytearray(gop_rom[:-1]))
		
		## Check if EFI is last image in Nvidia VBIOS. Change the bit in NPDE.
		check_nv_ext = reading[end_img_old:end_img_old + 2]
		if check_nv_ext == b'\x56\x4E' or check_nv_ext == b'\x55\xAA' :
			print(Style.BRIGHT + Fore.YELLOW + "  EFI is NOT last image!\n" + Fore.RESET + Style.NORMAL)
			efi_lst_new = int(efi_lst_old & 0x7F)
			efr_lst_new = int(efr_lst_old & 0x7F)
			## Remove end padding from dumped images.
			nv_step  = end_img_old
			
			while check_nv_ext == b'\x56\x4E' or check_nv_ext == b'\x55\xAA' :
				nv_ext_size = int.from_bytes(reading[nv_step + 2:nv_step + 4], 'little') * 0x200
				#print(nv_ext_size)
				
				if nv_ext_size == 0 :
					npds_off = int.from_bytes(reading[nv_step + 0x18:nv_step + 0x1A], 'little')
					npds_off += nv_step
					nv_ext_size = int.from_bytes(reading[npds_off + 0x10:npds_off + 0x12], 'little') * 0x200
					#print(nv_ext_size)
				
				nv_step += nv_ext_size
				check_nv_ext = reading[nv_step:nv_step + 2]
			else :
				if check_nv_ext == b'' :
					## No extra data and no padding, so we can re-add special images as end data.
					end_data = reading[end_img_old:]
				else :
					print(Style.BRIGHT + Fore.YELLOW + "  Removing unnecessary end padding.\n" + Fore.RESET + Style.NORMAL)
					end_data = reading[end_img_old:nv_step] ## This is the normal situation, where only padding follows last special image.
					str_err  = "  Data after Nvidia special images! Please report it!\n"
					end_img_new += nv_step - end_img_old
					end_data = remove_padding(end_data, nv_step, end_img_new, all_size, str_err)
		
		else :
			print(Style.BRIGHT + Fore.YELLOW + "  EFI is last image.\n" + Fore.RESET + Style.NORMAL)
			efi_lst_new = int(efi_lst_old | 0x80)
			efr_lst_new = int(efr_lst_old | 0x80)
			## Remove end padding from dumped images.
			end_data = b''
			
			if end_img_old < all_size :
				print(Style.BRIGHT + Fore.YELLOW + "  Removing unnecessary end padding.\n" + Fore.RESET + Style.NORMAL)
				str_err  = "  Data after ROM and not part of Nvidia special images! Please report it!\n"
				end_data = remove_padding(end_data, end_img_old, end_img_new, all_size, str_err)
		
		efi_id_new      = sum(bytearray(orom_id_bin))
		efi_lst_bin_new = bytes([efi_lst_new])
		efr_lst_bin_new = bytes([efr_lst_new])
		
		print(Style.BRIGHT + Fore.YELLOW + "  Fixing ID, last-image-bit and checksum for EFI image.\n" + Fore.RESET + Style.NORMAL)
		
		if orom_old_type :
			print(Style.BRIGHT + Fore.YELLOW + "  Fixing last-image-bit in PCIR and NPDE for EFI image.\n" + Fore.RESET + Style.NORMAL)
		else :
			efr_lst_new     = efr_lst_old
			efr_lst_bin_new = bytes([efr_lst_new])
				
		checksum_new    = (checksum_old - efi_id_old - efr_lst_old - efi_lst_old + efi_id_new + efr_lst_new + efi_lst_new) & 0xFF
		efi_chk_int_new = 256 - checksum_new if checksum_new else 0
		efi_chk_bin_new = bytes([efi_chk_int_new])
				
		new_gop += gop_rom[:efi_id_off] + orom_id_bin + gop_rom[efi_id_off + 4:efr_lst_off] + efr_lst_bin_new + \
					gop_rom[efr_lst_off + 1:efi_lst_off] + efi_lst_bin_new + gop_rom[efi_lst_off + 1:-1] + efi_chk_bin_new + end_data
	
	else :
		## gop_type is "AMD"
		## AMD has no special images, from limited testing.
		print(Style.BRIGHT + Fore.YELLOW + "  Fixing ID for EFI image. No checksum correction is needed.\n" + Fore.RESET + Style.NORMAL)
		
		## Remove end padding from dumped images.
		end_data = b''
		
		if end_img_old < all_size :
			print(Style.BRIGHT + Fore.YELLOW + "  Removing unnecessary end padding.\n" + Fore.RESET + Style.NORMAL)
			str_err  = "  Data after ROM and not part of EFI! Please report it!\n"
			end_data = remove_padding(end_data, end_img_old, end_img_new, all_size, str_err)
				
		new_gop += gop_rom[:efi_id_off] + orom_id_bin + gop_rom[efi_id_off + 4:] + end_data
	
	with open("%s_updGOP%s" % (fileName, fileExtension), 'wb') as my_gop :
		my_gop.write(new_gop)
	
	print(Style.BRIGHT + Fore.CYAN + "\nFile \"%s_updGOP%s\" with updated GOP %s was written!\n" % (fileName, fileExtension, last_gop) + 
	Fore.RESET + Style.NORMAL)