<?php
header('Content-Type: application/json');
header('Cache-Control: no-cache');
header('Access-Control-Allow-Origin: *');

$EXPIRATION_TIME = 600;    // 时间限制：10分钟无活动自动删除
$MAX_WAITING_ROOMS = 3;    // 数量限制：公屏最多显示3个待连接房间，超过删旧的

$code = $_GET['code'] ?? '';
$role = $_GET['role'] ?? ''; 
$action = $_GET['action'] ?? '';
$baseDir = __DIR__ . "/signals";

// 辅助函数：递归删除文件夹
function deleteDir($dirPath) {
    if (!is_dir($dirPath)) return;
    $files = glob($dirPath . '/*');
    foreach ($files as $file) {
        if (is_file($file)) unlink($file);
    }
    rmdir($dirPath);
}

// Action: Check (检查房间状态，不创建)
if ($action === 'check') {
    if (!$code) exit(json_encode(['error' => 'No code']));
    $dir = "$baseDir/$code";
    
    // 文件夹不存在，或者存在但没核心文件，都视为“发起者”
    if (!is_dir($dir)) {
        echo json_encode(['role' => 'offerer', 'exists' => false]);
        exit;
    }

    $hasOffer = file_exists("$dir/offer.json");
    $hasAnswer = file_exists("$dir/answer.json");
    
    if (!$hasOffer && !$hasAnswer) {
        echo json_encode(['role' => 'offerer', 'exists' => false]);
    } else {
        echo json_encode([
            'role' => ($hasOffer && !$hasAnswer) ? 'answerer' : 'offerer',
            'exists' => $hasOffer
        ]);
    }
    exit;
}

// Action: Browse (公屏逻辑 + 强力垃圾回收)
if ($action === 'browse') {
    if (!is_dir($baseDir)) mkdir($baseDir, 0777, true);
    
    $rooms = []; // 最终要返回给前端的房间列表
    $waitingRooms = []; // 用于记录“等待中”的房间及其时间戳，用于排序删除
    
    $dirs = glob("$baseDir/*", GLOB_ONLYDIR);
    $now = time();

    foreach ($dirs as $d) {
        $offerFile = "$d/offer.json";
        $answerFile = "$d/answer.json";

        // 基础时间回收 (10分钟超时)
        $lastMod = filemtime($d);
        $files = glob("$d/*.json");
        foreach($files as $f) {
            $t = filemtime($f);
            if ($t > $lastMod) $lastMod = $t;
        }
        if (($now - $lastMod) > $EXPIRATION_TIME) {
            deleteDir($d);
            continue;
        }

        // 收集活跃房间信息
        // 只有“有Offer且无Answer”的才算“等待连接”
        if (file_exists($offerFile) && !file_exists($answerFile)) {
            $rooms[] = basename($d);
            // 记录时间戳，为了稍后的数量限制
            $waitingRooms[$d] = filemtime($offerFile); 
        }
    }

    // 等待的房间超过配置数量检测
    if (count($waitingRooms) > $MAX_WAITING_ROOMS) {
        // 按时间升序排序 (旧的在前)
        asort($waitingRooms);
        
        // 计算需要删除几个
        $countToDelete = count($waitingRooms) - $MAX_WAITING_ROOMS;
        
        // 截取前 N 个 (最旧的)
        $dirsToDelete = array_slice(array_keys($waitingRooms), 0, $countToDelete);
        
        foreach ($dirsToDelete as $delPath) {
            deleteDir($delPath);
            
            // 从最终返回列表里剔除这个房间，防止前端显示一个刚被删掉的房间
            $roomName = basename($delPath);
            $key = array_search($roomName, $rooms);
            if ($key !== false) {
                unset($rooms[$key]);
            }
        }
        
        // 重置数组索引
        $rooms = array_values($rooms);
    }

    echo json_encode(['rooms' => $rooms]);
    exit;
}

// 以下是正常的信令交换

if (!$code) exit(json_encode(['error' => 'No code']));
$dir = "$baseDir/$code";

// 处理 POST (懒创建)
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!is_dir($dir)) mkdir($dir, 0777, true);

    $data = file_get_contents('php://input');
    $type = $_GET['type'] ?? ''; 
    
    touch($dir); // 更新文件夹时间防止被误删

    if ($type === 'candidate') {
        file_put_contents("$dir/candidates_" . microtime(true) . ".json", $data);
    } else {
        file_put_contents("$dir/$type.json", $data);
    }
    echo json_encode(['status' => 'ok']);
    exit;
}

// 处理 GET (读取并销毁)
if (!is_dir($dir)) {
    echo json_encode(['signals' => []]);
    exit;
}

$response = ['signals' => []];
$targetType = ($role === 'offerer') ? 'answer' : 'offer';
$targetFile = "$dir/$targetType.json";

if (file_exists($targetFile)) {
    $response['signals'][] = [
        'type' => 'signal',
        'data' => json_decode(file_get_contents($targetFile))
    ];
    unlink($targetFile); 
    touch($dir);
}

$files = glob("$dir/candidates_*.json");
foreach ($files as $file) {
    $response['signals'][] = [
        'type' => 'candidate',
        'data' => json_decode(file_get_contents($file))
    ];
    unlink($file); 
    touch($dir);
}

// 阅后即焚 (空文件夹清理)
$remainingFiles = array_diff(scandir($dir), array('.', '..'));
if (empty($remainingFiles)) {
    rmdir($dir);
}

echo json_encode($response);
